package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.EstudioDocAperturas;
import com.ejie.ab04b.model.TareaAperturas;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0464s00DaoImpl generated by UDA, 14-Feb-2017 10:29:39.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class EstudioDocAperturasDaoImpl implements EstudioDocAperturasDao {

	private static final String QUERY_SELECT = "SELECT t1.ID_TAREA_064 IDTAREA064, t1.RESULTADO_064 RESULTADO064, t1.NOTAS_064 NOTAS064 FROM AB0464S00 t1 ";

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<EstudioDocAperturas> rwMap = new RowMapper<EstudioDocAperturas>() {
		public EstudioDocAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EstudioDocAperturas(new TareaAperturas(
					resultSet.getLong("IDTAREA064")),
					resultSet.getString("RESULTADO064"),
					resultSet.getString("NOTAS064"));
		}
	};

	private RowMapper<EstudioDocAperturas> rwMapPK = new RowMapper<EstudioDocAperturas>() {
		public EstudioDocAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EstudioDocAperturas(new TareaAperturas(
					resultSet.getLong("IDTAREA064")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0464s00 table.
	 * 
	 * ab0464s00 Ab0464s00 Ab0464s00
	 * 
	 * @param ab0464s00
	 *            the ab 0464 s 00
	 * @return the estudio doc aperturas
	 */
	public EstudioDocAperturas add(EstudioDocAperturas ab0464s00) {
		String query = "INSERT INTO AB0464S00 (ID_TAREA_064, RESULTADO_064) VALUES (?,?)";
		this.jdbcTemplate.update(query, ab0464s00.getTareaAperturas()
				.getIdTarea063(), ab0464s00.getResultado064());
		return ab0464s00;
	}

	/**
	 * Updates a single row in the Ab0464s00 table.
	 * 
	 * ab0464s00 Ab0464s00 Ab0464s00
	 * 
	 * @param ab0464s00
	 *            the ab 0464 s 00
	 * @return the estudio doc aperturas
	 */
	public EstudioDocAperturas update(EstudioDocAperturas ab0464s00) {
		String query = "UPDATE AB0464S00 SET RESULTADO_064=?, NOTAS_064=? WHERE ID_TAREA_064=?";
		this.jdbcTemplate.update(query, ab0464s00.getResultado064(), ab0464s00
				.getNotas064(), ab0464s00.getTareaAperturas().getIdTarea063());
		return ab0464s00;
	}

	/**
	 * Finds a single row in the Ab0464s00 table.
	 * 
	 * ab0464s00 Ab0464s00 Ab0464s00
	 * 
	 * @param ab0464s00
	 *            the ab 0464 s 00
	 * @return the estudio doc aperturas
	 */
	@Transactional(readOnly = true)
	public EstudioDocAperturas find(EstudioDocAperturas ab0464s00) {
		StringBuilder query = new StringBuilder(
				EstudioDocAperturasDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TAREA_064 = ? ");

		List<EstudioDocAperturas> ab0464s00List = this.jdbcTemplate.query(query
				.toString(), this.rwMap, ab0464s00.getTareaAperturas()
				.getIdTarea063());
		return (EstudioDocAperturas) DataAccessUtils
				.uniqueResult(ab0464s00List);
	}

	/**
	 * Removes a single row in the Ab0464s00 table.
	 * 
	 * ab0464s00 Ab0464s00
	 * 
	 * @param ab0464s00
	 *            the ab 0464 s 00
	 */
	public void remove(EstudioDocAperturas ab0464s00) {
		String query = "DELETE FROM AB0464S00 WHERE ID_TAREA_064=?";
		this.jdbcTemplate.update(query, ab0464s00.getTareaAperturas()
				.getIdTarea063());
	}

	/**
	 * Finds a list of rows in the Ab0464s00 table.
	 * 
	 * ab0464s00 Ab0464s00 jqGridRequestDto JQGridRequestDto List<Ab0464s00>
	 * 
	 * @param ab0464s00
	 *            the ab 0464 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<EstudioDocAperturas> findAll(EstudioDocAperturas ab0464s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				EstudioDocAperturasDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0464s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<EstudioDocAperturas>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0464s00 table using like.
	 * 
	 * ab0464s00 Ab0464s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Ab0464s00>
	 * 
	 * @param ab0464s00
	 *            the ab 0464 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<EstudioDocAperturas> findAllLike(EstudioDocAperturas ab0464s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EstudioDocAperturasDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0464s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<EstudioDocAperturas>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0464s00 table.
	 * 
	 * ab0464s00 Ab0464s00 Long
	 * 
	 * @param ab0464s00
	 *            the ab 0464 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(EstudioDocAperturas ab0464s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0464S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0464s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0464s00 table using like.
	 * 
	 * ab0464s00 Ab0464s00 startsWith Boolean Long
	 * 
	 * @param ab0464s00
	 *            the ab 0464 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(EstudioDocAperturas ab0464s00,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0464S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0464s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0464s00 selected for rup_table.
	 * 
	 * ab0464s00 Ab0464s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<TableRowDto<Ab0464s00>>
	 * 
	 * @param ab0464s00
	 *            the ab 0464 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<EstudioDocAperturas>> reorderSelection(
			EstudioDocAperturas ab0464s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EstudioDocAperturasDaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0464s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, EstudioDocAperturas.class,
				filterParamList, "ID_ESTUDIO_APERTURA_064");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<EstudioDocAperturas>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams Ab0464s00 searchParams Ab0464s00 jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0464s00>>
	 * 
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<EstudioDocAperturas>> search(
			EstudioDocAperturas filterParams, EstudioDocAperturas searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				EstudioDocAperturasDaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, EstudioDocAperturas.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"ID_ESTUDIO_APERTURA_064");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<EstudioDocAperturas>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0464s00 entity.
	 * 
	 * ab0464s00 Ab0464s00 Bean with the criteria values to filter by. Map
	 * created with two keys key query stores the sql query syntax key params
	 * stores the parameter values to be used in the condition sentence.
	 * 
	 * @param ab0464s00
	 *            the ab 0464 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(EstudioDocAperturas ab0464s00) {

		StringBuilder where = new StringBuilder(
				EstudioDocAperturasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0464s00 != null && ab0464s00.getTareaAperturas() != null
				&& ab0464s00.getTareaAperturas().getIdTarea063() != null) {
			where.append(" AND t1.ID_TAREA_064 = ?");
			params.add(ab0464s00.getTareaAperturas().getIdTarea063());
		}
		if (ab0464s00 != null && ab0464s00.getResultado064() != null) {
			where.append(" AND t1.RESULTADO_064 = ?");
			params.add(ab0464s00.getResultado064());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0464s00 entity.
	 * 
	 * ab0464s00 Ab0464s00 Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param ab0464s00
	 *            the ab 0464 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(EstudioDocAperturas ab0464s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				EstudioDocAperturasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0464s00 != null && ab0464s00.getTareaAperturas() != null
				&& ab0464s00.getTareaAperturas().getIdTarea063() != null) {
			where.append(" AND t1.ID_TAREA_064 = ?");
			params.add(ab0464s00.getTareaAperturas().getIdTarea063());
		}
		if (ab0464s00 != null && ab0464s00.getResultado064() != null) {
			where.append(" AND UPPER(t1.RESULTADO_064) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0464s00.getResultado064().toUpperCase() + "%");
			} else {
				params.add("%" + ab0464s00.getResultado064().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.RESULTADO_064 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
